/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.dungeons;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.actions.GameActionManager;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.CardGroup;
import com.megacrit.cardcrawl.cards.SoulGroup;
import com.megacrit.cardcrawl.cards.colorless.SwiftStrike;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.ExceptionHandler;
import com.megacrit.cardcrawl.core.OverlayMenu;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.credits.CreditsScreen;
import com.megacrit.cardcrawl.daily.DailyMods;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.AbstractImageEvent;
import com.megacrit.cardcrawl.events.AbstractTextEvent;
import com.megacrit.cardcrawl.events.GenericEventDialog;
import com.megacrit.cardcrawl.events.RoomEventDialog;
import com.megacrit.cardcrawl.gashapon.GashaUnlockScreen;
import com.megacrit.cardcrawl.gashapon.GashaponRoom;
import com.megacrit.cardcrawl.helpers.CardHelper;
import com.megacrit.cardcrawl.helpers.CardLibrary;
import com.megacrit.cardcrawl.helpers.EventHelper;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.helpers.MathHelper;
import com.megacrit.cardcrawl.helpers.MonsterHelper;
import com.megacrit.cardcrawl.helpers.PotionHelper;
import com.megacrit.cardcrawl.helpers.RelicLibrary;
import com.megacrit.cardcrawl.helpers.TipTracker;
import com.megacrit.cardcrawl.localization.UIStrings;
import com.megacrit.cardcrawl.map.MapEdge;
import com.megacrit.cardcrawl.map.MapGenerator;
import com.megacrit.cardcrawl.map.MapRoomNode;
import com.megacrit.cardcrawl.map.RoomTypeAssigner;
import com.megacrit.cardcrawl.metrics.Metrics;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.monsters.MonsterGroup;
import com.megacrit.cardcrawl.monsters.MonsterInfo;
import com.megacrit.cardcrawl.potions.AbstractPotion;
import com.megacrit.cardcrawl.random.Random;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import com.megacrit.cardcrawl.relics.Girya;
import com.megacrit.cardcrawl.relics.PeacePipe;
import com.megacrit.cardcrawl.relics.Shovel;
import com.megacrit.cardcrawl.rewards.RewardItem;
import com.megacrit.cardcrawl.rewards.chests.AbstractChest;
import com.megacrit.cardcrawl.rewards.chests.CursedChest;
import com.megacrit.cardcrawl.rewards.chests.LargeChest;
import com.megacrit.cardcrawl.rewards.chests.MediumChest;
import com.megacrit.cardcrawl.rewards.chests.SmallChest;
import com.megacrit.cardcrawl.rooms.AbstractRoom;
import com.megacrit.cardcrawl.rooms.EmptyRoom;
import com.megacrit.cardcrawl.rooms.EventRoom;
import com.megacrit.cardcrawl.rooms.MonsterRoom;
import com.megacrit.cardcrawl.rooms.MonsterRoomBoss;
import com.megacrit.cardcrawl.rooms.MonsterRoomElite;
import com.megacrit.cardcrawl.rooms.RestRoom;
import com.megacrit.cardcrawl.rooms.ShopRoom;
import com.megacrit.cardcrawl.rooms.TreasureRoom;
import com.megacrit.cardcrawl.rooms.TreasureRoomBoss;
import com.megacrit.cardcrawl.rooms.VictoryRoom;
import com.megacrit.cardcrawl.scenes.AbstractScene;
import com.megacrit.cardcrawl.screens.CardRewardScreen;
import com.megacrit.cardcrawl.screens.CombatRewardScreen;
import com.megacrit.cardcrawl.screens.DeathScreen;
import com.megacrit.cardcrawl.screens.DiscardPileViewScreen;
import com.megacrit.cardcrawl.screens.DrawPileViewScreen;
import com.megacrit.cardcrawl.screens.DungeonMapScreen;
import com.megacrit.cardcrawl.screens.MasterDeckViewScreen;
import com.megacrit.cardcrawl.screens.options.SettingsScreen;
import com.megacrit.cardcrawl.screens.saveAndContinue.SaveAndContinue;
import com.megacrit.cardcrawl.screens.saveAndContinue.SaveFile;
import com.megacrit.cardcrawl.screens.select.BossRelicSelectScreen;
import com.megacrit.cardcrawl.screens.select.GridCardSelectScreen;
import com.megacrit.cardcrawl.screens.select.HandCardSelectScreen;
import com.megacrit.cardcrawl.screens.stats.StatsScreen;
import com.megacrit.cardcrawl.shop.ShopScreen;
import com.megacrit.cardcrawl.ui.FtueTip;
import com.megacrit.cardcrawl.ui.buttons.DynamicBanner;
import com.megacrit.cardcrawl.ui.buttons.DynamicButton;
import com.megacrit.cardcrawl.ui.panels.TopPanel;
import com.megacrit.cardcrawl.unlock.AbstractUnlock;
import com.megacrit.cardcrawl.unlock.UnlockCharacterScreen;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import com.megacrit.cardcrawl.vfx.AbstractGameEffect;
import com.megacrit.cardcrawl.vfx.GameSavedEffect;
import com.megacrit.cardcrawl.vfx.PlayerTurnEffect;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractDungeon {
    private static final Logger logger = LogManager.getLogger(AbstractDungeon.class.getName());
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("AbstractDungeon");
    public static final String[] TEXT = AbstractDungeon.uiStrings.TEXT;
    public static String name;
    public static String levelNum;
    public static String id;
    public static int floorNum;
    public static AbstractPlayer player;
    public static ArrayList<AbstractUnlock> unlocks;
    protected static float shrineChance;
    private static boolean firstChest;
    private static boolean encounteredCursedChest;
    protected static float cardUpgradedChance;
    public static AbstractCard transformedCard;
    public static boolean loading_post_combat;
    public static Random monsterRng;
    public static Random mapRng;
    public static Random eventRng;
    public static Random merchantRng;
    public static Random cardRng;
    public static Random treasureRng;
    public static Random relicRng;
    public static Random potionRng;
    public static Random monsterHpRng;
    public static Random aiRng;
    public static Random shuffleRng;
    public static Random cardRandomRng;
    public static Random miscRng;
    public static Long playtimeStart;
    public static CardGroup srcColorlessCardPool;
    public static CardGroup srcCurseCardPool;
    public static CardGroup srcCommonCardPool;
    public static CardGroup srcUncommonCardPool;
    public static CardGroup srcRareCardPool;
    public static CardGroup colorlessCardPool;
    public static CardGroup curseCardPool;
    public static CardGroup commonCardPool;
    public static CardGroup uncommonCardPool;
    public static CardGroup rareCardPool;
    public static ArrayList<Integer> acceptablePools;
    public static ArrayList<String> commonRelicPool;
    public static ArrayList<String> uncommonRelicPool;
    public static ArrayList<String> rareRelicPool;
    public static ArrayList<String> shopRelicPool;
    public static ArrayList<String> bossRelicPool;
    public static String lastMonsterKey;
    public static String lastCombatMetricKey;
    public static ArrayList<String> monsterList;
    public static ArrayList<String> eliteMonsterList;
    public static ArrayList<String> bossList;
    public static String bossKey;
    public static ArrayList<String> eventList;
    public static ArrayList<String> shrineList;
    public static ArrayList<String> specialOneTimeEventList;
    public static GameActionManager actionManager;
    public static ArrayList<AbstractGameEffect> topLevelEffects;
    public static ArrayList<AbstractGameEffect> topLevelEffectsQueue;
    public static ArrayList<AbstractGameEffect> effectList;
    public static ArrayList<AbstractGameEffect> effectsQueue;
    public static boolean turnPhaseEffectActive;
    public static Texture genericEventBg;
    public static float colorlessRareChance;
    protected static float shopRoomChance;
    protected static float restRoomChance;
    protected static float eventRoomChance;
    protected static float eliteRoomChance;
    protected static float treasureRoomChance;
    protected static int smallChestChance;
    protected static int mediumChestChance;
    protected static int largeChestChance;
    protected static int smallPotionChance;
    protected static int mediumPotionChance;
    protected static int largePotionChance;
    protected static int commonRelicChance;
    protected static int uncommonRelicChance;
    protected static int rareRelicChance;
    public static AbstractScene scene;
    public static MapRoomNode currMapNode;
    protected static ArrayList<ArrayList<MapRoomNode>> map;
    public static boolean leftRoomAvailable;
    public static boolean centerRoomAvailable;
    public static boolean rightRoomAvailable;
    public static boolean firstRoomChosen;
    public static int startRoom;
    public static final int MAP_HEIGHT = 15;
    public static final int MAP_WIDTH = 7;
    public static final int MAP_DENSITY = 6;
    public static Texture eventImg;
    public static RenderScene rs;
    public static ArrayList<Integer> pathX;
    public static ArrayList<Integer> pathY;
    public static Color topGradientColor;
    public static Color botGradientColor;
    public static float floorY;
    public static RoomEventDialog dialog;
    public static GenericEventDialog genericEventDialog;
    public static TopPanel topPanel;
    public static CardRewardScreen cardRewardScreen;
    public static CombatRewardScreen combatRewardScreen;
    public static BossRelicSelectScreen bossRelicScreen;
    public static MasterDeckViewScreen deckViewScreen;
    public static DiscardPileViewScreen discardPileViewScreen;
    public static DrawPileViewScreen gameDeckViewScreen;
    public static SettingsScreen settingsScreen;
    public static DungeonMapScreen dungeonMapScreen;
    public static GridCardSelectScreen gridSelectScreen;
    public static HandCardSelectScreen handCardSelectScreen;
    public static ShopScreen shopScreen;
    public static CreditsScreen creditsScreen;
    public static FtueTip ftue;
    public static DeathScreen deathScreen;
    public static UnlockCharacterScreen unlockScreen;
    public static GashaUnlockScreen gUnlockScreen;
    public static boolean isScreenUp;
    public static OverlayMenu overlayMenu;
    public static CurrentScreen screen;
    public static CurrentScreen previousScreen;
    public static DynamicBanner dynamicBanner;
    public static DynamicButton dynamicButton;
    public static boolean screenSwap;
    public static boolean isDungeonBeaten;
    public static int cardBlizzStartOffset;
    public static int cardBlizzRandomizer;
    public static int cardBlizzGrowth;
    public static int cardBlizzMaxOffset;
    public static boolean isFadingIn;
    public static boolean isFadingOut;
    public static boolean waitingOnFadeOut;
    protected static float fadeTimer;
    public static Color fadeColor;
    public static MapRoomNode nextRoom;
    public static float sceneOffsetY;
    public static float sceneOffsetTimer;
    public static ArrayList<String> relicsToRemoveOnStart;
    public static int bossCount;
    public static final float SCENE_OFFSET_TIME = 1.3f;
    private static final Logger LOGGER;

    public AbstractDungeon(String name, String levelId, AbstractPlayer p, ArrayList<String> newSpecialOneTimeEventList) {
        CardCrawlGame.dungeon = this;
        long startTime = System.currentTimeMillis();
        AbstractDungeon.name = name;
        id = levelId;
        player = p;
        topPanel.setPlayerName();
        topPanel.setDungeonName(CardCrawlGame.nextDungeon);
        actionManager = new GameActionManager();
        overlayMenu = new OverlayMenu(p);
        dynamicBanner = new DynamicBanner();
        dynamicButton = new DynamicButton();
        unlocks.clear();
        specialOneTimeEventList = newSpecialOneTimeEventList;
        isFadingIn = false;
        isFadingOut = false;
        waitingOnFadeOut = false;
        fadeTimer = 1.0f;
        isDungeonBeaten = false;
        isScreenUp = false;
        acceptablePools.clear();
        switch (name) {
            default: 
        }
        acceptablePools.add(1);
        acceptablePools.add(2);
        AbstractDungeon.dungeonTransitionSetup();
        this.generateMonsters();
        this.initializeBoss();
        bossKey = bossList.get(0);
        logger.info("[BOSS] " + bossList.get(0));
        this.initializeEventList();
        this.initializeEventImg();
        this.initializeShrineList();
        this.initializeCardPools();
        if (id.equals("Exordium")) {
            screen = CurrentScreen.NONE;
            isScreenUp = false;
        } else {
            screen = CurrentScreen.MAP;
            isScreenUp = true;
        }
        logger.info("Content generation time: " + (System.currentTimeMillis() - startTime) + "ms");
    }

    public AbstractDungeon(String name, AbstractPlayer p, SaveFile saveFile) {
        id = saveFile.level_name;
        CardCrawlGame.dungeon = this;
        long startTime = System.currentTimeMillis();
        AbstractDungeon.name = name;
        player = p;
        topPanel.setPlayerName();
        topPanel.setDungeonName(CardCrawlGame.nextDungeon);
        actionManager = new GameActionManager();
        overlayMenu = new OverlayMenu(p);
        dynamicBanner = new DynamicBanner();
        dynamicButton = new DynamicButton();
        isFadingIn = false;
        isFadingOut = false;
        waitingOnFadeOut = false;
        fadeTimer = 1.0f;
        isDungeonBeaten = false;
        isScreenUp = false;
        firstRoomChosen = true;
        unlocks.clear();
        acceptablePools.clear();
        acceptablePools.add(1);
        acceptablePools.add(2);
        try {
            this.loadSave(saveFile);
        }
        catch (Exception e) {
            logger.info("Deleting save due to crash...");
            SaveAndContinue.deleteSave(AbstractDungeon.player.chosenClass);
            ExceptionHandler.handleException(e, LOGGER);
            Gdx.app.exit();
        }
        this.initializeEventImg();
        this.initializeShrineList();
        this.initializeCardPools();
        screen = CurrentScreen.NONE;
        isScreenUp = false;
        logger.info("Dungeon load time: " + (System.currentTimeMillis() - startTime) + "ms");
    }

    protected abstract void initializeLevelSpecificChances();

    public static void generateSeeds() {
        logger.info("Generating seeds: " + Settings.seed);
        monsterRng = new Random(Settings.seed);
        eventRng = new Random(Settings.seed);
        merchantRng = new Random(Settings.seed);
        cardRng = new Random(Settings.seed);
        treasureRng = new Random(Settings.seed);
        relicRng = new Random(Settings.seed);
        monsterHpRng = new Random(Settings.seed);
        potionRng = new Random(Settings.seed);
        aiRng = new Random(Settings.seed);
        shuffleRng = new Random(Settings.seed);
        cardRandomRng = new Random(Settings.seed);
        miscRng = new Random(Settings.seed);
    }

    public static void loadSeeds(SaveFile save) {
        monsterRng = new Random(Settings.seed, save.monster_seed_count);
        eventRng = new Random(Settings.seed, save.event_seed_count);
        merchantRng = new Random(Settings.seed, save.merchant_seed_count);
        cardRng = new Random(Settings.seed, save.card_seed_count);
        treasureRng = new Random(Settings.seed, save.treasure_seed_count);
        relicRng = new Random(Settings.seed, save.relic_seed_count);
        potionRng = new Random(Settings.seed, save.potion_seed_count);
        logger.info("Loading seeds: " + Settings.seed);
        logger.info("Monster seed:  " + AbstractDungeon.monsterRng.counter);
        logger.info("Event seed:    " + AbstractDungeon.eventRng.counter);
        logger.info("Merchant seed: " + AbstractDungeon.merchantRng.counter);
        logger.info("Card seed:     " + AbstractDungeon.cardRng.counter);
        logger.info("Treasure seed: " + AbstractDungeon.treasureRng.counter);
        logger.info("Relic seed:    " + AbstractDungeon.relicRng.counter);
        logger.info("Potion seed:   " + AbstractDungeon.potionRng.counter);
    }

    public void populatePathTaken(SaveFile saveFile) {
        MapRoomNode node = null;
        if (saveFile.current_room.equals(MonsterRoomBoss.class.getName())) {
            node = new MapRoomNode(-1, 15);
            node.room = new MonsterRoomBoss();
            nextRoom = node;
        } else if (saveFile.current_room.equals(TreasureRoomBoss.class.getName())) {
            node = new MapRoomNode(-1, 15);
            node.room = new TreasureRoomBoss();
            nextRoom = node;
        } else if (saveFile.room_y == 15 && saveFile.room_x == -1) {
            node = new MapRoomNode(-1, 15);
            node.room = new VictoryRoom();
            nextRoom = node;
        } else {
            nextRoom = saveFile.floor_num == 0 ? null : map.get(saveFile.room_y).get(saveFile.room_x);
        }
        for (int i = 0; i < pathX.size(); ++i) {
            MapEdge connectedEdge;
            if (pathY.get(i) == 14) {
                MapRoomNode node2 = map.get(pathY.get(i)).get(pathX.get(i));
                for (MapEdge e : node2.getEdges()) {
                    if (e == null) continue;
                    e.markAsTaken();
                }
            }
            if (pathY.get(i) >= 15) continue;
            AbstractDungeon.map.get((int)AbstractDungeon.pathY.get((int)i).intValue()).get((int)AbstractDungeon.pathX.get((int)i).intValue()).taken = true;
            if (node != null && (connectedEdge = node.getEdgeConnectedTo(map.get(pathY.get(i)).get(pathX.get(i)))) != null) {
                connectedEdge.markAsTaken();
            }
            node = map.get(pathY.get(i)).get(pathX.get(i));
        }
        if (saveFile.floor_num == 0) {
            logger.info("Loading into Neow");
            currMapNode = new MapRoomNode(0, -1);
            AbstractDungeon.currMapNode.room = new EmptyRoom();
        } else {
            logger.info("Loading into: " + saveFile.room_x + "," + saveFile.room_y);
            currMapNode = new MapRoomNode(0, -1);
            AbstractDungeon.currMapNode.room = new EmptyRoom();
        }
        this.nextRoomTransition();
        if (saveFile.floor_num == 0) {
            if (saveFile.chose_neow_reward) {
                AbstractDungeon.currMapNode.room = new GashaponRoom(true);
            } else {
                CardCrawlGame.playerPref.putInteger(AbstractDungeon.player.chosenClass.name() + "_SPIRITS", 1);
                AbstractDungeon.currMapNode.room = new GashaponRoom(false);
            }
        }
    }

    public static AbstractChest getRandomChest() {
        int roll = treasureRng.random(0, 99);
        if (roll < smallChestChance) {
            firstChest = false;
            return new SmallChest();
        }
        if (roll < mediumChestChance + smallChestChance) {
            firstChest = false;
            return new MediumChest();
        }
        if (roll < largeChestChance + mediumChestChance + smallChestChance) {
            firstChest = false;
            return new LargeChest();
        }
        if (firstChest) {
            firstChest = false;
            return new SmallChest();
        }
        if (!encounteredCursedChest) {
            encounteredCursedChest = true;
            return new CursedChest();
        }
        return new SmallChest();
    }

    protected static void generateMap() {
        if (player.hasRelic("Membership Card")) {
            float tmp;
            shopRoomChance = tmp = shopRoomChance * 1.5f;
            eventRoomChance -= (tmp -= shopRoomChance) / 2.0f;
        }
        long startTime = System.currentTimeMillis();
        int mapHeight = 15;
        int mapWidth = 7;
        int mapPathDensity = 6;
        ArrayList<AbstractRoom> roomList = new ArrayList<AbstractRoom>();
        map = MapGenerator.generateDungeon(mapHeight, mapWidth, mapPathDensity, mapRng);
        int count = 0;
        for (ArrayList<MapRoomNode> a : map) {
            for (MapRoomNode n : a) {
                if (!n.hasEdges() || n.y == map.size() - 2) continue;
                ++count;
            }
        }
        AbstractDungeon.generateRoomTypes(roomList, count);
        RoomTypeAssigner.assignRowAsRoomType(map.get(map.size() - 1), RestRoom.class);
        RoomTypeAssigner.assignRowAsRoomType(map.get(0), MonsterRoom.class);
        RoomTypeAssigner.assignRowAsRoomType(map.get(8), TreasureRoom.class);
        map = RoomTypeAssigner.distributeRoomsAcrossMap(mapRng, map, roomList);
        logger.info("Generated the following dungeon map:");
        logger.info(MapGenerator.toString(map, true));
        logger.info("Game Seed: " + Settings.seed);
        logger.info("Map generation time: " + (System.currentTimeMillis() - startTime) + "ms");
        firstRoomChosen = false;
        if (Settings.mapDebugMode) {
            Settings.isDebug = true;
            LOGGER.warn("EnvVar 'STS_MAP_DEBUG=true', proceeding to draw map and exit.");
            System.exit(0);
        }
        AbstractDungeon.fadeIn();
    }

    private static void generateRoomTypes(ArrayList<AbstractRoom> roomList, int availableRoomCount) {
        int i;
        int eliteCount;
        logger.info("Generating Room Types! There are " + availableRoomCount + " rooms:");
        int shopCount = Math.round((float)availableRoomCount * shopRoomChance);
        logger.info(" SHOP (" + AbstractDungeon.toPercentage(shopRoomChance) + "): " + shopCount);
        int restCount = Math.round((float)availableRoomCount * restRoomChance);
        logger.info(" REST (" + AbstractDungeon.toPercentage(restRoomChance) + "): " + restCount);
        int treasureCount = Math.round((float)availableRoomCount * treasureRoomChance);
        logger.info(" TRSRE (" + AbstractDungeon.toPercentage(treasureRoomChance) + "): " + treasureCount);
        if (DailyMods.mods.get("Double Elites").booleanValue()) {
            eliteCount = Math.round((float)availableRoomCount * (eliteRoomChance * 2.0f));
            logger.info(" ELITE (" + AbstractDungeon.toPercentage(eliteRoomChance) + "): " + eliteCount);
        } else {
            eliteCount = Math.round((float)availableRoomCount * eliteRoomChance);
            logger.info(" ELITE (" + AbstractDungeon.toPercentage(eliteRoomChance) + "): " + eliteCount);
        }
        int eventCount = Math.round((float)availableRoomCount * eventRoomChance);
        logger.info(" EVNT (" + AbstractDungeon.toPercentage(eventRoomChance) + "): " + eventCount);
        int monsterCount = availableRoomCount - shopCount - restCount - treasureCount - eliteCount - eventCount;
        logger.info(" MSTR (" + AbstractDungeon.toPercentage(1.0f - shopRoomChance - restRoomChance - treasureRoomChance - eliteRoomChance - eventRoomChance) + "): " + monsterCount);
        for (i = 0; i < shopCount; ++i) {
            roomList.add(new ShopRoom());
        }
        for (i = 0; i < restCount; ++i) {
            roomList.add(new RestRoom());
        }
        for (i = 0; i < eliteCount; ++i) {
            roomList.add(new MonsterRoomElite());
        }
        for (i = 0; i < eventCount; ++i) {
            roomList.add(new EventRoom());
        }
    }

    private static String toPercentage(float n) {
        return String.format("%.0f", Float.valueOf(n * 100.0f)) + "%";
    }

    private static void firstRoomLogic() {
        AbstractDungeon.initializeFirstRoom();
        leftRoomAvailable = currMapNode.leftNodeAvailable();
        centerRoomAvailable = currMapNode.centerNodeAvailable();
        rightRoomAvailable = currMapNode.rightNodeAvailable();
    }

    private boolean passesDonutCheck(ArrayList<ArrayList<MapRoomNode>> map) {
        logger.info("CASEY'S DONUT CHECK: ");
        int width = map.get(0).size();
        int height = map.size();
        logger.info(" HEIGHT: " + height);
        logger.info(" WIDTH:  " + width);
        int nodeCount = 0;
        boolean[] roomHasNode = new boolean[width];
        for (int i = 0; i < width; ++i) {
            roomHasNode[i] = false;
        }
        ArrayList<MapRoomNode> secondToLastRow = map.get(map.size() - 2);
        for (MapRoomNode n : secondToLastRow) {
            for (MapEdge e : n.getEdges()) {
                roomHasNode[e.dstX] = true;
            }
        }
        for (int i = 0; i < width - 1; ++i) {
            if (!roomHasNode[i]) continue;
            ++nodeCount;
        }
        if (nodeCount != 1) {
            logger.info(" [FAIL] " + nodeCount + " NODES IN LAST ROW");
            return false;
        }
        logger.info(" [SUCCESS] " + nodeCount + " NODE IN LAST ROW");
        int roomCount = 0;
        for (ArrayList<MapRoomNode> rows : map) {
            for (MapRoomNode n : rows) {
                if (n.room == null) continue;
                ++roomCount;
            }
        }
        logger.info(" ROOM COUNT: " + roomCount);
        return true;
    }

    public static AbstractRoom getCurrRoom() {
        return currMapNode.getRoom();
    }

    public static MapRoomNode getCurrMapNode() {
        return currMapNode;
    }

    public static void setCurrMapNode(MapRoomNode currMapNode) {
        SoulGroup group = AbstractDungeon.currMapNode.room.souls;
        AbstractDungeon.currMapNode = currMapNode;
        AbstractDungeon.currMapNode.room.souls = group;
    }

    public static ArrayList<MapRoomNode> identifyAvailableNodes(ArrayList<MapRoomNode> nodes) {
        ArrayList<MapRoomNode> nodesWithEdges = new ArrayList<MapRoomNode>();
        for (MapRoomNode node : nodes) {
            if (!node.hasEdges()) continue;
            nodesWithEdges.add(node);
        }
        return nodesWithEdges;
    }

    public static MapRoomNode getRandomNodeWithEdges(Random rng, ArrayList<MapRoomNode> nodes) {
        MapRoomNode node = nodes.size() == 1 ? nodes.get(0) : nodes.get(rng.random.nextInt(nodes.size()));
        if (node.hasEdges()) {
            return node;
        }
        return null;
    }

    public ArrayList<ArrayList<MapRoomNode>> getMap() {
        return map;
    }

    public static AbstractRelic returnRandomRelic(AbstractRelic.RelicTier tier) {
        logger.info("Returning " + tier.name() + " relic");
        return RelicLibrary.getRelic(AbstractDungeon.returnRandomRelicKey(tier)).makeCopy();
    }

    public static AbstractRelic returnRandomScreenlessRelic(AbstractRelic.RelicTier tier) {
        logger.info("Returning " + tier.name() + " relic");
        AbstractRelic tmpRelic = RelicLibrary.getRelic(AbstractDungeon.returnRandomRelicKey(tier)).makeCopy();
        while (Objects.equals(tmpRelic.relicId, "Molten Egg") || Objects.equals(tmpRelic.relicId, "Toxic Egg") || Objects.equals(tmpRelic.relicId, "Frozen Egg") || Objects.equals(tmpRelic.relicId, "Bottled Flame") || Objects.equals(tmpRelic.relicId, "Bottled Lightning") || Objects.equals(tmpRelic.relicId, "Bottled Tornado") || Objects.equals(tmpRelic.relicId, "Whetstone")) {
            tmpRelic = RelicLibrary.getRelic(AbstractDungeon.returnRandomRelicKey(tier)).makeCopy();
        }
        return tmpRelic;
    }

    public static AbstractRelic returnRandomRelicEnd(AbstractRelic.RelicTier tier) {
        logger.info("Returning " + tier.name() + " relic");
        return RelicLibrary.getRelic(AbstractDungeon.returnEndRandomRelicKey(tier)).makeCopy();
    }

    public static String returnEndRandomRelicKey(AbstractRelic.RelicTier tier) {
        String retVal = null;
        switch (tier) {
            case COMMON: {
                if (commonRelicPool.isEmpty()) {
                    retVal = AbstractDungeon.returnRandomRelicKey(AbstractRelic.RelicTier.UNCOMMON);
                    break;
                }
                retVal = commonRelicPool.remove(commonRelicPool.size() - 1);
                break;
            }
            case UNCOMMON: {
                if (uncommonRelicPool.isEmpty()) {
                    retVal = AbstractDungeon.returnRandomRelicKey(AbstractRelic.RelicTier.RARE);
                    break;
                }
                retVal = uncommonRelicPool.remove(uncommonRelicPool.size() - 1);
                break;
            }
            case RARE: {
                if (rareRelicPool.isEmpty()) {
                    retVal = "Circlet";
                    break;
                }
                retVal = rareRelicPool.remove(rareRelicPool.size() - 1);
                break;
            }
            case SHOP: {
                if (shopRelicPool.isEmpty()) {
                    retVal = AbstractDungeon.returnRandomRelicKey(AbstractRelic.RelicTier.UNCOMMON);
                    break;
                }
                retVal = shopRelicPool.remove(shopRelicPool.size() - 1);
                break;
            }
            case BOSS: {
                if (bossRelicPool.isEmpty()) {
                    retVal = "Red Circlet";
                    break;
                }
                retVal = bossRelicPool.remove(0);
                break;
            }
        }
        if (retVal.equals("Peace Pipe") || retVal.equals("Shovel") || retVal.equals("Girya")) {
            int campfireCount = 0;
            for (AbstractRelic r : AbstractDungeon.player.relics) {
                if (!(r instanceof PeacePipe) && !(r instanceof Shovel) && !(r instanceof Girya)) continue;
                ++campfireCount;
            }
            if (campfireCount >= 2) {
                return AbstractDungeon.returnEndRandomRelicKey(tier);
            }
        }
        if ((retVal.equals("Frozen Egg") || retVal.equals("Bottled Tornado")) && !CardHelper.hasUpgradeablePowerCard()) {
            return AbstractDungeon.returnEndRandomRelicKey(tier);
        }
        if (retVal.equals("Black Blood") && !player.hasRelic("Burning Blood")) {
            return AbstractDungeon.returnEndRandomRelicKey(tier);
        }
        if (retVal.equals("Ring of the Serpent") && !player.hasRelic("Ring of the Snake")) {
            return AbstractDungeon.returnEndRandomRelicKey(tier);
        }
        return retVal;
    }

    public static String returnRandomRelicKey(AbstractRelic.RelicTier tier) {
        String retVal = null;
        switch (tier) {
            case COMMON: {
                if (commonRelicPool.isEmpty()) {
                    retVal = AbstractDungeon.returnRandomRelicKey(AbstractRelic.RelicTier.UNCOMMON);
                    break;
                }
                retVal = commonRelicPool.remove(0);
                break;
            }
            case UNCOMMON: {
                if (uncommonRelicPool.isEmpty()) {
                    retVal = AbstractDungeon.returnRandomRelicKey(AbstractRelic.RelicTier.RARE);
                    break;
                }
                retVal = uncommonRelicPool.remove(0);
                break;
            }
            case RARE: {
                if (rareRelicPool.isEmpty()) {
                    retVal = "Circlet";
                    break;
                }
                retVal = rareRelicPool.remove(0);
                break;
            }
            case SHOP: {
                if (shopRelicPool.isEmpty()) {
                    retVal = AbstractDungeon.returnRandomRelicKey(AbstractRelic.RelicTier.UNCOMMON);
                    break;
                }
                retVal = shopRelicPool.remove(0);
                break;
            }
            case BOSS: {
                if (bossRelicPool.isEmpty()) {
                    retVal = "Red Circlet";
                    break;
                }
                retVal = bossRelicPool.remove(0);
                break;
            }
        }
        if (retVal.equals("Peace Pipe") || retVal.equals("Shovel") || retVal.equals("Girya")) {
            int campfireCount = 0;
            for (AbstractRelic r : AbstractDungeon.player.relics) {
                if (!(r instanceof PeacePipe) && !(r instanceof Shovel) && !(r instanceof Girya)) continue;
                ++campfireCount;
            }
            if (campfireCount >= 2) {
                return AbstractDungeon.returnRandomRelicKey(tier);
            }
        }
        if ((retVal.equals("Frozen Egg") || retVal.equals("Bottled Tornado")) && !CardHelper.hasUpgradeablePowerCard()) {
            return AbstractDungeon.returnRandomRelicKey(tier);
        }
        if (retVal.equals("Black Blood") && !player.hasRelic("Burning Blood")) {
            return AbstractDungeon.returnRandomRelicKey(tier);
        }
        if (retVal.equals("Ring of the Serpent") && !player.hasRelic("Ring of the Snake")) {
            return AbstractDungeon.returnRandomRelicKey(tier);
        }
        return retVal;
    }

    public static AbstractRelic.RelicTier returnRandomRelicTier() {
        int roll = relicRng.random(0, 99);
        if (roll < commonRelicChance) {
            return AbstractRelic.RelicTier.COMMON;
        }
        if (roll < commonRelicChance + uncommonRelicChance) {
            return AbstractRelic.RelicTier.UNCOMMON;
        }
        return AbstractRelic.RelicTier.RARE;
    }

    public static AbstractPotion returnRandomPotion(int modifier) {
        return PotionHelper.getRandomPotion();
    }

    public static AbstractPotion returnRandomPotion() {
        return AbstractDungeon.returnRandomPotion(0);
    }

    public static void transformCard(AbstractCard c) {
        AbstractDungeon.transformCard(c, false);
    }

    public static void transformCard(AbstractCard c, boolean autoUpgrade) {
        AbstractDungeon.transformCard(c, autoUpgrade, new Random());
    }

    public static void transformCard(AbstractCard c, boolean autoUpgrade, Random rng) {
        block0 : switch (c.color) {
            case COLORLESS: {
                transformedCard = AbstractDungeon.returnTrulyRandomColorlessCardFromAvailable(c, rng).makeCopy();
                break;
            }
            case CURSE: {
                transformedCard = CardLibrary.getCurse(c).makeCopy();
                break;
            }
            default: {
                transformedCard = AbstractDungeon.returnTrulyRandomCardFromAvailable(c, rng).makeCopy();
                switch (c.rarity) {
                    case BASIC: {
                        break block0;
                    }
                    case COMMON: {
                        commonCardPool.addToTop(c.makeCopy());
                        break block0;
                    }
                    case UNCOMMON: {
                        uncommonCardPool.addToTop(c.makeCopy());
                        break block0;
                    }
                    case RARE: {
                        rareCardPool.addToTop(c.makeCopy());
                        break block0;
                    }
                    case CURSE: {
                        break block0;
                    }
                    case SPECIAL: {
                        break block0;
                    }
                }
                logger.info("Transform called on a strange card type: " + c.type.name());
            }
        }
        UnlockTracker.markCardAsSeen(AbstractDungeon.transformedCard.cardID);
        if (autoUpgrade && transformedCard.canUpgrade()) {
            transformedCard.upgrade();
        }
    }

    public static void srcTransformCard(AbstractCard c) {
        logger.info("Transform using SRC pool...");
        switch (c.rarity) {
            case BASIC: {
                transformedCard = srcCommonCardPool.getRandomCard(false).makeCopy();
                break;
            }
            case COMMON: {
                srcCommonCardPool.removeCard(c.cardID);
                transformedCard = srcCommonCardPool.getRandomCard(false).makeCopy();
                srcCommonCardPool.addToTop(c.makeCopy());
                break;
            }
            case UNCOMMON: {
                srcUncommonCardPool.removeCard(c.cardID);
                transformedCard = srcUncommonCardPool.getRandomCard(false).makeCopy();
                srcUncommonCardPool.addToTop(c.makeCopy());
                break;
            }
            case RARE: {
                srcRareCardPool.removeCard(c.cardID);
                transformedCard = srcRareCardPool.isEmpty() ? srcUncommonCardPool.getRandomCard(false).makeCopy() : srcRareCardPool.getRandomCard(false).makeCopy();
                srcRareCardPool.addToTop(c.makeCopy());
                break;
            }
            case CURSE: {
                transformedCard = !srcRareCardPool.isEmpty() ? srcRareCardPool.getRandomCard(false).makeCopy() : srcUncommonCardPool.getRandomCard(false).makeCopy();
            }
            default: {
                logger.info("Transform called on a strange card type: " + c.type.name());
                transformedCard = srcCommonCardPool.getRandomCard(false).makeCopy();
            }
        }
    }

    public static AbstractCard returnTrulyRandomCard() {
        ArrayList<AbstractCard> list = new ArrayList<AbstractCard>();
        list.addAll(AbstractDungeon.srcCommonCardPool.group);
        list.addAll(AbstractDungeon.srcUncommonCardPool.group);
        list.addAll(AbstractDungeon.srcRareCardPool.group);
        return (AbstractCard)list.get(MathUtils.random(list.size() - 1));
    }

    public static AbstractCard returnTrulyRandomCard(AbstractCard.CardType type) {
        ArrayList<AbstractCard> list = new ArrayList<AbstractCard>();
        for (AbstractCard c : AbstractDungeon.srcCommonCardPool.group) {
            if (c.type != type) continue;
            list.add(c);
        }
        for (AbstractCard c : AbstractDungeon.srcUncommonCardPool.group) {
            if (c.type != type) continue;
            list.add(c);
        }
        for (AbstractCard c : AbstractDungeon.srcRareCardPool.group) {
            if (c.type != type) continue;
            list.add(c);
        }
        return (AbstractCard)list.get(MathUtils.random(list.size() - 1));
    }

    public static AbstractCard returnTrulyRandomCardWithSubtype(AbstractCard.CardSubType subType) {
        ArrayList<AbstractCard> list = new ArrayList<AbstractCard>();
        for (AbstractCard c : AbstractDungeon.srcCommonCardPool.group) {
            if (c.subType != subType) continue;
            list.add(c);
        }
        for (AbstractCard c : AbstractDungeon.srcUncommonCardPool.group) {
            if (c.subType != subType) continue;
            list.add(c);
        }
        for (AbstractCard c : AbstractDungeon.srcRareCardPool.group) {
            if (c.subType != subType) continue;
            list.add(c);
        }
        return (AbstractCard)list.get(MathUtils.random(list.size() - 1));
    }

    public static AbstractCard returnTrulyRandomColorlessCard() {
        ArrayList<AbstractCard> list = new ArrayList<AbstractCard>();
        list.addAll(AbstractDungeon.srcColorlessCardPool.group);
        return (AbstractCard)list.get(MathUtils.random(list.size() - 1));
    }

    public static AbstractCard returnTrulyRandomColorlessCardFromAvailable(AbstractCard prohibited, Random rng) {
        ArrayList<AbstractCard> list = new ArrayList<AbstractCard>();
        for (AbstractCard c : AbstractDungeon.srcColorlessCardPool.group) {
            if (Objects.equals(c.cardID, prohibited.cardID)) continue;
            list.add(c);
        }
        return (AbstractCard)list.get(rng.random(list.size() - 1));
    }

    public static AbstractCard returnTrulyRandomColorlessCardFromAvailable(AbstractCard prohibited) {
        return AbstractDungeon.returnTrulyRandomColorlessCardFromAvailable(prohibited, new Random());
    }

    public static AbstractCard returnTrulyRandomCardFromAvailable(AbstractCard prohibited, Random rng) {
        ArrayList<AbstractCard> list = new ArrayList<AbstractCard>();
        switch (prohibited.color) {
            case COLORLESS: {
                for (AbstractCard c : AbstractDungeon.colorlessCardPool.group) {
                    if (Objects.equals(c.cardID, prohibited.cardID)) continue;
                    list.add(c);
                }
                break;
            }
            case CURSE: {
                return CardLibrary.getCurse(1);
            }
            default: {
                for (AbstractCard c : AbstractDungeon.commonCardPool.group) {
                    if (Objects.equals(c.cardID, prohibited.cardID)) continue;
                    list.add(c);
                }
                for (AbstractCard c : AbstractDungeon.srcUncommonCardPool.group) {
                    if (Objects.equals(c.cardID, prohibited.cardID)) continue;
                    list.add(c);
                }
                for (AbstractCard c : AbstractDungeon.srcRareCardPool.group) {
                    if (Objects.equals(c.cardID, prohibited.cardID)) continue;
                    list.add(c);
                }
            }
        }
        return ((AbstractCard)list.get(rng.random(list.size() - 1))).makeCopy();
    }

    public static AbstractCard returnTrulyRandomCardFromAvailable(AbstractCard prohibited) {
        return AbstractDungeon.returnTrulyRandomCardFromAvailable(prohibited, new Random());
    }

    public static AbstractCard getTransformedCard() {
        AbstractCard retVal = transformedCard;
        transformedCard = null;
        return retVal;
    }

    public void populateFirstStrongEnemy(ArrayList<MonsterInfo> monsters, ArrayList<String> exclusions) {
        String m;
        while (exclusions.contains(m = MonsterInfo.roll(monsters, monsterRng.random()))) {
        }
        monsterList.add(m);
    }

    public void populateMonsterList(ArrayList<MonsterInfo> monsters, int numMonsters, boolean elites) {
        if (elites) {
            for (int i = 0; i < numMonsters; ++i) {
                if (eliteMonsterList.isEmpty()) {
                    eliteMonsterList.add(MonsterInfo.roll(monsters, monsterRng.random()));
                    continue;
                }
                String toAdd = MonsterInfo.roll(monsters, monsterRng.random());
                if (!toAdd.equals(eliteMonsterList.get(eliteMonsterList.size() - 1))) {
                    eliteMonsterList.add(toAdd);
                    continue;
                }
                --i;
            }
        } else {
            for (int i = 0; i < numMonsters; ++i) {
                if (monsterList.isEmpty()) {
                    monsterList.add(MonsterInfo.roll(monsters, monsterRng.random()));
                    continue;
                }
                String toAdd = MonsterInfo.roll(monsters, monsterRng.random());
                if (!toAdd.equals(monsterList.get(monsterList.size() - 1))) {
                    if (monsterList.size() > 1 && toAdd.equals(monsterList.get(monsterList.size() - 2))) {
                        --i;
                        continue;
                    }
                    monsterList.add(toAdd);
                    continue;
                }
                --i;
            }
        }
    }

    protected abstract ArrayList<String> generateExclusions();

    public static AbstractCard returnColorlessCard(AbstractCard.CardRarity rarity) {
        Collections.shuffle(AbstractDungeon.colorlessCardPool.group);
        for (AbstractCard c : AbstractDungeon.colorlessCardPool.group) {
            if (c.rarity != rarity) continue;
            return c.makeCopy();
        }
        if (rarity == AbstractCard.CardRarity.RARE) {
            for (AbstractCard c : AbstractDungeon.colorlessCardPool.group) {
                if (c.rarity != AbstractCard.CardRarity.UNCOMMON) continue;
                return c.makeCopy();
            }
        }
        return new SwiftStrike();
    }

    public static AbstractCard returnColorlessCard() {
        Collections.shuffle(AbstractDungeon.colorlessCardPool.group);
        Iterator<AbstractCard> iterator = AbstractDungeon.colorlessCardPool.group.iterator();
        if (iterator.hasNext()) {
            AbstractCard c = iterator.next();
            return c.makeCopy();
        }
        return new SwiftStrike();
    }

    public static AbstractCard returnRandomCurse() {
        UnlockTracker.markCardAsSeen(CardLibrary.getCurse((int)1).cardID);
        return CardLibrary.getCurse(1).makeCopy();
    }

    public void initializeCardPools() {
        logger.info("INIT CARD POOL");
        long startTime = System.currentTimeMillis();
        commonCardPool.clear();
        uncommonCardPool.clear();
        rareCardPool.clear();
        colorlessCardPool.clear();
        curseCardPool.clear();
        ArrayList<AbstractCard> tmpPool = new ArrayList<AbstractCard>();
        switch (AbstractDungeon.player.chosenClass) {
            case IRONCLAD: {
                this.addRedCards(tmpPool);
                break;
            }
            case THE_SILENT: {
                this.addGreenCards(tmpPool);
                break;
            }
            case CROWBOT: {
                this.addBlueCards(tmpPool);
                break;
            }
        }
        this.addColorlessCards();
        this.addCurseCards();
        for (AbstractCard c : tmpPool) {
            block12: for (int i : acceptablePools) {
                if (c.pool == i) {
                    switch (c.rarity) {
                        case COMMON: {
                            commonCardPool.addToTop(c);
                            continue block12;
                        }
                        case UNCOMMON: {
                            uncommonCardPool.addToTop(c);
                            continue block12;
                        }
                        case RARE: {
                            rareCardPool.addToTop(c);
                            continue block12;
                        }
                        case CURSE: {
                            curseCardPool.addToTop(c);
                            continue block12;
                        }
                    }
                    logger.info("Unspecified rarity: " + c.rarity.name() + " when creating pools! AbstractDungeon: Line 827");
                    continue;
                }
                if (!Settings.isInfo) continue;
                logger.info("Card " + c.name + " not added to " + name + " as it is pool " + c.pool);
            }
        }
        srcColorlessCardPool = new CardGroup(CardGroup.CardGroupType.CARD_POOL);
        srcCurseCardPool = new CardGroup(CardGroup.CardGroupType.CARD_POOL);
        srcRareCardPool = new CardGroup(CardGroup.CardGroupType.CARD_POOL);
        srcUncommonCardPool = new CardGroup(CardGroup.CardGroupType.CARD_POOL);
        srcCommonCardPool = new CardGroup(CardGroup.CardGroupType.CARD_POOL);
        for (AbstractCard c : AbstractDungeon.colorlessCardPool.group) {
            srcColorlessCardPool.addToBottom(c);
        }
        for (AbstractCard c : AbstractDungeon.curseCardPool.group) {
            srcCurseCardPool.addToBottom(c);
        }
        for (AbstractCard c : AbstractDungeon.rareCardPool.group) {
            srcRareCardPool.addToBottom(c);
        }
        for (AbstractCard c : AbstractDungeon.uncommonCardPool.group) {
            srcUncommonCardPool.addToBottom(c);
        }
        for (AbstractCard c : AbstractDungeon.commonCardPool.group) {
            srcCommonCardPool.addToBottom(c);
        }
        logger.info("Cardpool load time: " + (System.currentTimeMillis() - startTime) + "ms");
    }

    private void addColorlessCards() {
        AbstractCard card = null;
        for (Map.Entry<String, AbstractCard> c : CardLibrary.cards.entrySet()) {
            card = c.getValue();
            if (card.color != AbstractCard.CardColor.COLORLESS || card.rarity == AbstractCard.CardRarity.BASIC) continue;
            colorlessCardPool.addToTop(card);
        }
        logger.info("COLORLESS CARDS: " + colorlessCardPool.size());
    }

    private void addCurseCards() {
        AbstractCard card = null;
        for (Map.Entry<String, AbstractCard> c : CardLibrary.cards.entrySet()) {
            card = c.getValue();
            if (card.type != AbstractCard.CardType.CURSE || Objects.equals(card.cardID, "Necronomicurse")) continue;
            curseCardPool.addToTop(card);
        }
        logger.info("CURSE CARDS: " + colorlessCardPool.size());
    }

    private void addRedCards(ArrayList<AbstractCard> tmpPool) {
        AbstractCard card = null;
        for (Map.Entry<String, AbstractCard> c : CardLibrary.cards.entrySet()) {
            card = c.getValue();
            if (card.color != AbstractCard.CardColor.RED || card.rarity == AbstractCard.CardRarity.BASIC || UnlockTracker.isCardLocked(c.getKey()) && !Settings.isDailyRun) continue;
            tmpPool.add(card);
        }
    }

    private void addGreenCards(ArrayList<AbstractCard> tmpPool) {
        AbstractCard card = null;
        for (Map.Entry<String, AbstractCard> c : CardLibrary.cards.entrySet()) {
            card = c.getValue();
            if (card.color != AbstractCard.CardColor.GREEN || card.rarity == AbstractCard.CardRarity.BASIC || UnlockTracker.isCardLocked(c.getKey()) && !Settings.isDailyRun) continue;
            tmpPool.add(card);
        }
    }

    private void addBlueCards(ArrayList<AbstractCard> tmpPool) {
        AbstractCard card = null;
        for (Map.Entry<String, AbstractCard> c : CardLibrary.cards.entrySet()) {
            card = c.getValue();
            if (card.color != AbstractCard.CardColor.BLUE || card.rarity == AbstractCard.CardRarity.BASIC || UnlockTracker.isCardLocked(c.getKey()) && !Settings.isDailyRun) continue;
            tmpPool.add(card);
        }
    }

    protected void initializeRelicList() {
        commonRelicPool.clear();
        uncommonRelicPool.clear();
        rareRelicPool.clear();
        shopRelicPool.clear();
        bossRelicPool.clear();
        RelicLibrary.populateRelicPool(commonRelicPool, AbstractRelic.RelicTier.COMMON, AbstractDungeon.player.chosenClass);
        RelicLibrary.populateRelicPool(uncommonRelicPool, AbstractRelic.RelicTier.UNCOMMON, AbstractDungeon.player.chosenClass);
        RelicLibrary.populateRelicPool(rareRelicPool, AbstractRelic.RelicTier.RARE, AbstractDungeon.player.chosenClass);
        RelicLibrary.populateRelicPool(shopRelicPool, AbstractRelic.RelicTier.SHOP, AbstractDungeon.player.chosenClass);
        RelicLibrary.populateRelicPool(bossRelicPool, AbstractRelic.RelicTier.BOSS, AbstractDungeon.player.chosenClass);
        Collections.shuffle(commonRelicPool, AbstractDungeon.relicRng.random);
        Collections.shuffle(uncommonRelicPool, AbstractDungeon.relicRng.random);
        Collections.shuffle(rareRelicPool, AbstractDungeon.relicRng.random);
        Collections.shuffle(shopRelicPool, AbstractDungeon.relicRng.random);
        Collections.shuffle(bossRelicPool, AbstractDungeon.relicRng.random);
        block0: for (String remove : relicsToRemoveOnStart) {
            String derp;
            Iterator<String> s = commonRelicPool.iterator();
            while (s.hasNext()) {
                derp = s.next();
                if (!derp.equals(remove)) continue;
                s.remove();
                logger.info(derp + " removed.");
                break;
            }
            s = uncommonRelicPool.iterator();
            while (s.hasNext()) {
                derp = s.next();
                if (!derp.equals(remove)) continue;
                s.remove();
                logger.info(derp + " removed.");
                break;
            }
            s = rareRelicPool.iterator();
            while (s.hasNext()) {
                derp = s.next();
                if (!derp.equals(remove)) continue;
                s.remove();
                logger.info(derp + " removed.");
                break;
            }
            s = bossRelicPool.iterator();
            while (s.hasNext()) {
                derp = s.next();
                if (!derp.equals(remove)) continue;
                s.remove();
                logger.info(derp + " removed.");
                break;
            }
            s = shopRelicPool.iterator();
            while (s.hasNext()) {
                derp = s.next();
                if (!derp.equals(remove)) continue;
                s.remove();
                logger.info(derp + " removed.");
                continue block0;
            }
        }
        if (Settings.isDebug) {
            logger.info("Relic (Common):");
            for (String s : commonRelicPool) {
                logger.info(" " + s);
            }
            logger.info("Relic (Uncommon):");
            for (String s : uncommonRelicPool) {
                logger.info(" " + s);
            }
            logger.info("Relic (Rare):");
            for (String s : rareRelicPool) {
                logger.info(" " + s);
            }
            logger.info("Relic (Shop):");
            for (String s : shopRelicPool) {
                logger.info(" " + s);
            }
            logger.info("Relic (Boss):");
            for (String s : bossRelicPool) {
                logger.info(" " + s);
            }
        }
    }

    protected abstract void generateMonsters();

    protected abstract void initializeBoss();

    protected abstract void initializeEventList();

    protected abstract void initializeEventImg();

    protected abstract void initializeShrineList();

    public void initializeSpecialOneTimeEventList() {
        specialOneTimeEventList.clear();
        specialOneTimeEventList.add("Accursed Blacksmith");
        specialOneTimeEventList.add("Bonfire Elementals");
        specialOneTimeEventList.add("Fountain of Cleansing");
        specialOneTimeEventList.add("Duplicator");
        specialOneTimeEventList.add("Knowing Skull");
        specialOneTimeEventList.add("Lab");
        specialOneTimeEventList.add("N'loth");
        specialOneTimeEventList.add("The Joust");
        specialOneTimeEventList.add("The Woman in Blue");
    }

    public static ArrayList<AbstractCard> getBossRewardCards() {
        ArrayList<AbstractCard> retVal = new ArrayList<AbstractCard>();
        int numCards = 3;
        if (player.hasRelic("Question Card")) {
            numCards = 4;
        }
        for (int i = 0; i < numCards; ++i) {
            AbstractCard.CardRarity rarity = AbstractCard.CardRarity.RARE;
            AbstractCard card = null;
            switch (rarity) {
                case RARE: {
                    card = AbstractDungeon.getCard(rarity);
                    cardBlizzRandomizer = cardBlizzStartOffset;
                    break;
                }
                case UNCOMMON: {
                    card = AbstractDungeon.getCard(rarity);
                    break;
                }
                case COMMON: {
                    card = AbstractDungeon.getCard(rarity);
                    if ((cardBlizzRandomizer -= cardBlizzGrowth) > cardBlizzMaxOffset) break;
                    cardBlizzRandomizer = cardBlizzMaxOffset;
                    break;
                }
                default: {
                    logger.info("WTF?");
                }
            }
            while (retVal.contains(card)) {
                logger.info("DUPE: " + card.originalName);
                card = AbstractDungeon.getCard(rarity);
            }
            retVal.add(card);
        }
        ArrayList<AbstractCard> retVal2 = new ArrayList<AbstractCard>();
        for (AbstractCard c : retVal) {
            retVal2.add(c.makeCopy());
        }
        return retVal2;
    }

    public static ArrayList<AbstractCard> getRewardCards() {
        ArrayList<AbstractCard> retVal = new ArrayList<AbstractCard>();
        int numCards = 3;
        if (player.hasRelic("Question Card")) {
            numCards = 4;
        }
        for (int i = 0; i < numCards; ++i) {
            AbstractCard.CardRarity rarity = AbstractDungeon.rollRarity();
            AbstractCard card = null;
            switch (rarity) {
                case RARE: {
                    card = AbstractDungeon.getCard(rarity);
                    cardBlizzRandomizer = cardBlizzStartOffset;
                    break;
                }
                case UNCOMMON: {
                    card = AbstractDungeon.getCard(rarity);
                    break;
                }
                case COMMON: {
                    card = AbstractDungeon.getCard(rarity);
                    if ((cardBlizzRandomizer -= cardBlizzGrowth) > cardBlizzMaxOffset) break;
                    cardBlizzRandomizer = cardBlizzMaxOffset;
                    break;
                }
                default: {
                    logger.info("WTF?");
                }
            }
            int dupeCount = 0;
            block11: while (retVal.contains(card)) {
                logger.info("DUPE: " + card.originalName);
                if (dupeCount < 4) {
                    card = AbstractDungeon.getCard(rarity);
                    continue;
                }
                logger.info("FALLBACK FOR CARD RARITY HAS OCCURRED");
                switch (rarity) {
                    case RARE: {
                        card = AbstractDungeon.getCard(AbstractCard.CardRarity.UNCOMMON);
                        continue block11;
                    }
                    case UNCOMMON: {
                        card = AbstractDungeon.getCard(AbstractCard.CardRarity.COMMON);
                        continue block11;
                    }
                    case COMMON: {
                        card = AbstractDungeon.getCard(AbstractCard.CardRarity.UNCOMMON);
                        continue block11;
                    }
                }
                card = AbstractDungeon.getCard(AbstractCard.CardRarity.COMMON);
            }
            retVal.add(card);
        }
        ArrayList<AbstractCard> retVal2 = new ArrayList<AbstractCard>();
        for (AbstractCard c : retVal) {
            retVal2.add(c.makeCopy());
        }
        for (AbstractCard c : retVal2) {
            if (c.rarity == AbstractCard.CardRarity.RARE || !cardRng.randomBoolean(cardUpgradedChance) || !c.canUpgrade()) continue;
            c.upgrade();
        }
        return retVal2;
    }

    public static AbstractCard getCard(AbstractCard.CardRarity rarity) {
        switch (rarity) {
            case RARE: {
                return rareCardPool.getRandomCard(true);
            }
            case UNCOMMON: {
                return uncommonCardPool.getRandomCard(true);
            }
            case COMMON: {
                return commonCardPool.getRandomCard(true);
            }
            case CURSE: {
                return curseCardPool.getRandomCard(true);
            }
        }
        logger.info("No rarity on getCard in Abstract Dungeon");
        return null;
    }

    public static AbstractCard getCard(AbstractCard.CardRarity rarity, Random rng) {
        switch (rarity) {
            case RARE: {
                return rareCardPool.getRandomCard(rng);
            }
            case UNCOMMON: {
                return uncommonCardPool.getRandomCard(rng);
            }
            case COMMON: {
                return commonCardPool.getRandomCard(rng);
            }
            case CURSE: {
                return curseCardPool.getRandomCard(rng);
            }
        }
        logger.info("No rarity on getCard in Abstract Dungeon");
        return null;
    }

    public static AbstractCard getCardWithoutRng(AbstractCard.CardRarity rarity) {
        switch (rarity) {
            case RARE: {
                return rareCardPool.getRandomCard(false);
            }
            case UNCOMMON: {
                return uncommonCardPool.getRandomCard(false);
            }
            case COMMON: {
                return commonCardPool.getRandomCard(false);
            }
            case CURSE: {
                return AbstractDungeon.returnRandomCurse();
            }
        }
        logger.info("Check getCardWithoutRng");
        return null;
    }

    public static AbstractCard getCardFromPool(AbstractCard.CardRarity rarity, AbstractCard.CardType type, boolean useRng) {
        switch (rarity) {
            case RARE: {
                AbstractCard retVal = rareCardPool.getRandomCard(type, useRng);
                if (retVal != null) {
                    return retVal;
                }
                logger.info("ERROR: Could not find Rare card of type: " + type.name());
            }
            case UNCOMMON: {
                AbstractCard retVal = uncommonCardPool.getRandomCard(type, useRng);
                if (retVal != null) {
                    return retVal;
                }
                if (type == AbstractCard.CardType.POWER) {
                    return AbstractDungeon.getCardFromPool(AbstractCard.CardRarity.RARE, type, useRng);
                }
                logger.info("ERROR: Could not find Uncommon card of type: " + type.name());
            }
            case COMMON: {
                AbstractCard retVal = commonCardPool.getRandomCard(type, useRng);
                if (retVal != null) {
                    return retVal;
                }
                if (type == AbstractCard.CardType.POWER) {
                    return AbstractDungeon.getCardFromPool(AbstractCard.CardRarity.UNCOMMON, type, useRng);
                }
                logger.info("ERROR: Could not find Common card of type: " + type.name());
            }
            case CURSE: {
                AbstractCard retVal = curseCardPool.getRandomCard(type, useRng);
                if (retVal != null) {
                    return retVal;
                }
                logger.info("ERROR: Could not find Curse card of type: " + type.name());
            }
        }
        logger.info("ERROR: Default in getCardFromPool");
        return null;
    }

    public static AbstractCard getColorlessCardFromPool(AbstractCard.CardRarity rarity) {
        switch (rarity) {
            case RARE: {
                AbstractCard retVal = colorlessCardPool.getRandomCard(true, rarity);
                if (retVal != null) {
                    return retVal;
                }
            }
            case UNCOMMON: {
                AbstractCard retVal = colorlessCardPool.getRandomCard(true, rarity);
                if (retVal == null) break;
                return retVal;
            }
        }
        logger.info("ERROR: getColorlessCardFromPool");
        return null;
    }

    public static void removeCardFromPool(String id, String name, AbstractCard.CardRarity rarity, AbstractCard.CardColor color) {
        block15: {
            block14: {
                if (color == AbstractCard.CardColor.COLORLESS || color == AbstractCard.CardColor.CURSE) break block14;
                switch (rarity) {
                    case RARE: {
                        Iterator<AbstractCard> i = AbstractDungeon.rareCardPool.group.iterator();
                        while (i.hasNext()) {
                            AbstractCard e = i.next();
                            if (!e.cardID.equals(id)) continue;
                            i.remove();
                            logger.info(name + " removed from pool.");
                            return;
                        }
                        break block15;
                    }
                    case UNCOMMON: {
                        Iterator<AbstractCard> i = AbstractDungeon.uncommonCardPool.group.iterator();
                        while (i.hasNext()) {
                            AbstractCard e = i.next();
                            if (!e.cardID.equals(id)) continue;
                            i.remove();
                            logger.info(name + " removed from pool.");
                            return;
                        }
                        break block15;
                    }
                    case COMMON: {
                        Iterator<AbstractCard> i = AbstractDungeon.commonCardPool.group.iterator();
                        while (i.hasNext()) {
                            AbstractCard e = i.next();
                            if (!e.cardID.equals(id)) continue;
                            i.remove();
                            logger.info(name + " removed from pool.");
                            return;
                        }
                        break block15;
                    }
                    default: {
                        logger.info("ERROR: Rarity incorrectly specified: " + rarity.name());
                        break;
                    }
                }
                break block15;
            }
            if (color == AbstractCard.CardColor.COLORLESS) {
                Iterator<AbstractCard> i = AbstractDungeon.colorlessCardPool.group.iterator();
                while (i.hasNext()) {
                    AbstractCard e = i.next();
                    if (!e.cardID.equals(id)) continue;
                    i.remove();
                    logger.info(name + " removed from pool.");
                    return;
                }
            } else if (color == AbstractCard.CardColor.CURSE) {
                Iterator<AbstractCard> i = AbstractDungeon.curseCardPool.group.iterator();
                while (i.hasNext()) {
                    AbstractCard e = i.next();
                    if (!e.cardID.equals(id)) continue;
                    i.remove();
                    logger.info(name + " removed from pool.");
                    return;
                }
            } else {
                logger.info("ERROR: Somebody used removeCardFromPool() incorrectly!!");
            }
        }
    }

    public static AbstractCard.CardRarity rollRarity(Random rng) {
        int roll = cardRng.random(99);
        return AbstractDungeon.getCurrRoom().getCardRarity(roll += cardBlizzRandomizer);
    }

    public static AbstractCard.CardRarity rollRarity() {
        return AbstractDungeon.rollRarity(cardRng);
    }

    public static AbstractCard.CardRarity rollRareOrUncommon(float rareChance) {
        if (cardRng.randomBoolean(rareChance)) {
            return AbstractCard.CardRarity.RARE;
        }
        return AbstractCard.CardRarity.UNCOMMON;
    }

    public static AbstractMonster getRandomMonster() {
        return AbstractDungeon.getRandomMonster(null);
    }

    public static AbstractMonster getRandomMonster(AbstractMonster except) {
        return AbstractDungeon.currMapNode.room.monsters.getRandomMonster(except, true);
    }

    public static void nextRoomTransitionStart() {
        AbstractDungeon.fadeOut();
        waitingOnFadeOut = true;
        AbstractDungeon.overlayMenu.proceedButton.hide();
    }

    public static void initializeFirstRoom() {
        AbstractDungeon.fadeIn();
        ++floorNum;
        if (AbstractDungeon.currMapNode.room instanceof MonsterRoom) {
            if (!CardCrawlGame.loadingSave) {
                if (!(Settings.isDailyRun || Settings.isTrial || Settings.isDemo)) {
                    SaveFile saveFile = new SaveFile(SaveFile.SaveType.ENTER_ROOM);
                    SaveAndContinue.save(saveFile);
                    effectList.add(new GameSavedEffect());
                } else if (Settings.isDailyRun) {
                    Metrics metrics = new Metrics();
                    metrics.setValues(false, null, Metrics.MetricRequestType.NONE);
                    metrics.gatherAllDataAndSave(false, null);
                }
            }
            --floorNum;
        }
        scene.nextRoom(AbstractDungeon.currMapNode.room);
    }

    public void nextRoomTransition() {
        if (player.hasRelic("Singing Bowl")) {
            for (RewardItem rewardItem : AbstractDungeon.combatRewardScreen.rewards) {
                if (rewardItem.type != RewardItem.RewardType.CARD) continue;
                CardCrawlGame.sound.play("SINGING_BOWL");
                player.increaseMaxHp(2, false);
            }
        }
        if (!(AbstractDungeon.player.gold <= 5000 && AbstractDungeon.player.masterDeck.size() <= 120 && AbstractDungeon.player.relics.size() <= 60 || Settings.isBeta)) {
            CardCrawlGame.playerPref.putBoolean("funMode", true);
            CardCrawlGame.playerPref.flush();
        }
        AbstractDungeon.overlayMenu.proceedButton.setLabel(TEXT[0]);
        sceneOffsetTimer = 1.3f;
        combatRewardScreen.clear();
        if (nextRoom != null) {
            AbstractDungeon.nextRoom.room.rewards.clear();
        }
        previousScreen = null;
        dynamicBanner.hide();
        dungeonMapScreen.closeInstantly();
        AbstractDungeon.closeCurrentScreen();
        topPanel.unhoverHitboxes();
        AbstractDungeon.fadeIn();
        genericEventDialog.clear();
        dialog.hide();
        dialog.clear();
        effectList.clear();
        topLevelEffects.clear();
        topLevelEffectsQueue.clear();
        effectsQueue.clear();
        AbstractDungeon.dungeonMapScreen.dismissable = true;
        AbstractDungeon.player.animX = 0.0f;
        AbstractDungeon.player.animY = 0.0f;
        player.hideHealthBar();
        AbstractDungeon.player.hand.clear();
        AbstractDungeon.player.powers.clear();
        AbstractDungeon.player.drawPile.clear();
        AbstractDungeon.player.discardPile.clear();
        player.loseBlock(true);
        AbstractDungeon.player.damagedThisCombat = 0;
        GameActionManager.turn = 1;
        if (!CardCrawlGame.loadingSave) {
            this.incrementFloorBasedMetrics();
            if (!TipTracker.tips.get("INTENT_TIP").booleanValue() && ++floorNum == 6) {
                TipTracker.neverShowAgain("INTENT_TIP");
            }
            StatsScreen.incrementFloorClimbed();
            if (!(Settings.isDailyRun || Settings.isTrial || Settings.isDemo)) {
                SaveFile saveFile = new SaveFile(SaveFile.SaveType.ENTER_ROOM);
                SaveAndContinue.save(saveFile);
                effectList.add(new GameSavedEffect());
            } else if (Settings.isDailyRun) {
                Metrics metrics = new Metrics();
                metrics.setValues(false, null, Metrics.MetricRequestType.NONE);
                metrics.gatherAllDataAndSave(false, null);
            }
        }
        monsterHpRng = new Random(Settings.seed, floorNum);
        aiRng = new Random(Settings.seed, floorNum);
        shuffleRng = new Random(Settings.seed, floorNum);
        cardRandomRng = new Random(Settings.seed, floorNum);
        miscRng = new Random(Settings.seed, floorNum);
        if (nextRoom != null) {
            for (AbstractRelic abstractRelic : AbstractDungeon.player.relics) {
                abstractRelic.onEnterRoom(AbstractDungeon.nextRoom.room);
            }
        }
        if (!AbstractDungeon.actionManager.actions.isEmpty()) {
            logger.info("[WARNING] Line:1904: Action Manager was NOT clear! Clearing");
            actionManager.clear();
        }
        if (nextRoom != null) {
            if (AbstractDungeon.nextRoom.room instanceof EventRoom) {
                AbstractDungeon.nextRoom.room = this.generateRoom(EventHelper.roll());
                AbstractDungeon.nextRoom.room.setMapImg(ImageMaster.MAP_NODE_EVENT, ImageMaster.MAP_NODE_EVENT_OUTLINE);
            } else if (AbstractDungeon.nextRoom.room instanceof MonsterRoomBoss) {
                AbstractMonster.preloadBossStinger();
                logger.info("WALKING INTO BOSS ROOM");
            }
            AbstractDungeon.setCurrMapNode(nextRoom);
        }
        AbstractDungeon.getCurrRoom().onPlayerEntry();
        if (AbstractDungeon.currMapNode.room instanceof MonsterRoom) {
            player.preBattlePrep();
        }
        scene.nextRoom(AbstractDungeon.currMapNode.room);
        rs = AbstractDungeon.currMapNode.room instanceof RestRoom ? RenderScene.CAMPFIRE : (AbstractDungeon.currMapNode.room.event instanceof AbstractTextEvent || AbstractDungeon.currMapNode.room.event instanceof AbstractImageEvent ? RenderScene.EVENT : RenderScene.NORMAL);
    }

    private void incrementFloorBasedMetrics() {
        if (floorNum != 0) {
            CardCrawlGame.metricData.current_hp_per_floor.add(AbstractDungeon.player.currentHealth);
            CardCrawlGame.metricData.max_hp_per_floor.add(AbstractDungeon.player.maxHealth);
            CardCrawlGame.metricData.gold_per_floor.add(AbstractDungeon.player.gold);
            CardCrawlGame.metricData.path_per_floor.add(AbstractDungeon.getCurrMapNode().getRoomSymbol(true));
        }
    }

    private AbstractRoom generateRoom(EventHelper.RoomResult roomType) {
        logger.info("GENERATING ROOM: " + roomType.name());
        switch (roomType) {
            case ELITE: {
                return new MonsterRoomElite();
            }
            case MONSTER: {
                return new MonsterRoom();
            }
            case SHOP: {
                return new ShopRoom();
            }
            case TREASURE: {
                return new TreasureRoom();
            }
        }
        return new EventRoom();
    }

    public static MonsterGroup getMonsters() {
        return AbstractDungeon.getCurrRoom().monsters;
    }

    public static MonsterGroup getMonsterForRoomCreation() {
        lastCombatMetricKey = monsterList.get(0);
        logger.info("Monster Removed");
        return MonsterHelper.getEncounter(monsterList.remove(0));
    }

    public static MonsterGroup getEliteMonsterForRoomCreation() {
        lastCombatMetricKey = eliteMonsterList.get(0);
        return MonsterHelper.getEncounter(eliteMonsterList.remove(0));
    }

    public static AbstractEvent generateEvent() {
        if (eventRng.random(1.0f) < shrineChance) {
            if (!shrineList.isEmpty() || !specialOneTimeEventList.isEmpty()) {
                return AbstractDungeon.getShrine();
            }
            if (!eventList.isEmpty()) {
                return AbstractDungeon.getEvent();
            }
            logger.info("No events or shrines left");
            return null;
        }
        AbstractEvent retVal = AbstractDungeon.getEvent();
        if (retVal == null) {
            return AbstractDungeon.getShrine();
        }
        return retVal;
    }

    public static AbstractEvent getShrine() {
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.addAll(shrineList);
        Iterator<String> iterator = specialOneTimeEventList.iterator();
        block16: while (iterator.hasNext()) {
            String e;
            switch (e = iterator.next()) {
                case "Fountain of Cleansing": {
                    if (!player.isCursed()) continue block16;
                    tmp.add(e);
                    continue block16;
                }
                case "Duplicator": {
                    if (!id.equals("TheCity") && !id.equals("TheBeyond")) continue block16;
                    tmp.add(e);
                    continue block16;
                }
                case "Knowing Skull": {
                    if (!id.equals("TheCity") || AbstractDungeon.player.currentHealth <= AbstractDungeon.player.maxHealth / 2) continue block16;
                    tmp.add(e);
                    continue block16;
                }
                case "N'loth": {
                    if (!id.equals("TheCity") && !id.equals("TheCity") || AbstractDungeon.player.relics.size() < 2) continue block16;
                    tmp.add(e);
                    continue block16;
                }
                case "The Joust": {
                    if (!id.equals("TheCity") || AbstractDungeon.player.gold < 50) continue block16;
                    tmp.add(e);
                    continue block16;
                }
                case "The Woman in Blue": {
                    if (AbstractDungeon.player.gold < 50) continue block16;
                    tmp.add(e);
                    continue block16;
                }
            }
            tmp.add(e);
        }
        String tmpKey = (String)tmp.get(eventRng.random(tmp.size() - 1));
        shrineList.remove(tmpKey);
        specialOneTimeEventList.remove(tmpKey);
        logger.info("Removed event: " + tmpKey + " from pool.");
        return EventHelper.getEvent(tmpKey);
    }

    public static AbstractEvent getEvent() {
        ArrayList<String> tmp = new ArrayList<String>();
        Iterator<String> iterator = eventList.iterator();
        block10: while (iterator.hasNext()) {
            String e;
            switch (e = iterator.next()) {
                case "Dead Adventurer": {
                    if (floorNum <= 6) continue block10;
                    tmp.add(e);
                    continue block10;
                }
                case "Mushrooms": {
                    if (floorNum <= 6) continue block10;
                    tmp.add(e);
                    continue block10;
                }
                case "The Moai Head": {
                    if (!player.hasRelic("Golden Idol") && (float)AbstractDungeon.player.currentHealth / (float)AbstractDungeon.player.maxHealth > 0.5f) continue block10;
                    tmp.add(e);
                    continue block10;
                }
            }
            tmp.add(e);
        }
        if (tmp.isEmpty()) {
            return AbstractDungeon.getShrine();
        }
        String tmpKey = (String)tmp.get(eventRng.random(tmp.size() - 1));
        eventList.remove(tmpKey);
        logger.info("Removed event: " + tmpKey + " from pool.");
        return EventHelper.getEvent(tmpKey);
    }

    public MonsterGroup getBoss() {
        lastCombatMetricKey = bossKey;
        AbstractDungeon.dungeonMapScreen.map.atBoss = true;
        return MonsterHelper.getEncounter(bossKey);
    }

    public void update() {
        AbstractGameEffect e;
        this.updateSceneOffset();
        topPanel.update();
        dynamicButton.update();
        dynamicBanner.update();
        this.updateFading();
        AbstractDungeon.currMapNode.room.updateObjects();
        if (isScreenUp) {
            AbstractDungeon.topGradientColor.a = MathHelper.fadeLerpSnap(AbstractDungeon.topGradientColor.a, 0.25f);
            AbstractDungeon.botGradientColor.a = MathHelper.fadeLerpSnap(AbstractDungeon.botGradientColor.a, 0.25f);
        } else {
            AbstractDungeon.topGradientColor.a = MathHelper.fadeLerpSnap(AbstractDungeon.topGradientColor.a, 0.1f);
            AbstractDungeon.botGradientColor.a = MathHelper.fadeLerpSnap(AbstractDungeon.botGradientColor.a, 0.1f);
        }
        switch (screen) {
            case NONE: {
                dungeonMapScreen.update();
                AbstractDungeon.currMapNode.room.update();
                scene.update();
                dialog.update();
                genericEventDialog.update();
                break;
            }
            case FTUE: {
                ftue.update();
                InputHelper.justClickedRight = false;
                InputHelper.justClickedLeft = false;
                AbstractDungeon.currMapNode.room.update();
                break;
            }
            case MASTER_DECK_VIEW: {
                deckViewScreen.update();
                break;
            }
            case GAME_DECK_VIEW: {
                gameDeckViewScreen.update();
                break;
            }
            case DISCARD_VIEW: {
                discardPileViewScreen.update();
                break;
            }
            case SETTINGS: {
                settingsScreen.update();
                break;
            }
            case MAP: {
                dungeonMapScreen.update();
                break;
            }
            case GRID: {
                gridSelectScreen.update();
                break;
            }
            case CARD_REWARD: {
                cardRewardScreen.update();
                break;
            }
            case COMBAT_REWARD: {
                combatRewardScreen.update();
                break;
            }
            case BOSS_REWARD: {
                bossRelicScreen.update();
                AbstractDungeon.currMapNode.room.update();
                break;
            }
            case HAND_SELECT: {
                handCardSelectScreen.update();
                break;
            }
            case SHOP: {
                shopScreen.update();
                break;
            }
            case DEATH: {
                deathScreen.update();
                break;
            }
            case UNLOCK: {
                unlockScreen.update();
                break;
            }
            case GASHA_UNLOCK: {
                gUnlockScreen.update();
                break;
            }
            case CREDITS: {
                creditsScreen.update();
                break;
            }
            default: {
                logger.info("ERROR: UNKNOWN SCREEN TO UPDATE: " + screen.name());
            }
        }
        turnPhaseEffectActive = false;
        Iterator<AbstractGameEffect> i = topLevelEffects.iterator();
        while (i.hasNext()) {
            e = i.next();
            e.update();
            if (!e.isDone) continue;
            i.remove();
        }
        i = effectList.iterator();
        while (i.hasNext()) {
            e = i.next();
            e.update();
            if (e instanceof PlayerTurnEffect) {
                turnPhaseEffectActive = true;
            }
            if (!e.isDone) continue;
            i.remove();
        }
        i = effectsQueue.iterator();
        while (i.hasNext()) {
            e = i.next();
            effectList.add(e);
            i.remove();
        }
        i = topLevelEffectsQueue.iterator();
        while (i.hasNext()) {
            e = i.next();
            topLevelEffects.add(e);
            i.remove();
        }
        overlayMenu.update();
    }

    private void updateSceneOffset() {
        if (sceneOffsetTimer != 0.0f && (sceneOffsetTimer -= Gdx.graphics.getDeltaTime()) < 0.0f) {
            sceneOffsetY = 0.0f;
            sceneOffsetTimer = 0.0f;
        }
    }

    public void render(SpriteBatch sb) {
        switch (rs) {
            case NORMAL: {
                scene.renderCombatRoomBg(sb);
                break;
            }
            case CAMPFIRE: {
                scene.renderCampfireRoom(sb);
                break;
            }
            case EVENT: {
                scene.renderEventRoom(sb);
            }
        }
        dynamicButton.render(sb);
        for (AbstractGameEffect e : effectList) {
            if (!e.renderBehind) continue;
            e.render(sb);
        }
        AbstractDungeon.currMapNode.room.render(sb);
        overlayMenu.renderBgPanels(sb);
        switch (rs) {
            case NORMAL: {
                scene.renderCombatRoomFg(sb);
                break;
            }
        }
        if (rs == RenderScene.NORMAL) {
            scene.renderCombatRoomFg(sb);
        }
        if (AbstractDungeon.getCurrRoom() instanceof EventRoom || AbstractDungeon.getCurrRoom() instanceof GashaponRoom || AbstractDungeon.getCurrRoom() instanceof VictoryRoom) {
            dialog.render(sb);
            genericEventDialog.render(sb);
        }
        for (AbstractGameEffect e : effectList) {
            if (e.renderBehind) continue;
            e.render(sb);
        }
        overlayMenu.render(sb);
        overlayMenu.renderBlackScreen(sb);
        switch (screen) {
            case NONE: {
                dungeonMapScreen.render(sb);
                break;
            }
            case MASTER_DECK_VIEW: {
                deckViewScreen.render(sb);
                break;
            }
            case DISCARD_VIEW: {
                discardPileViewScreen.render(sb);
                break;
            }
            case GAME_DECK_VIEW: {
                gameDeckViewScreen.render(sb);
                break;
            }
            case SETTINGS: {
                settingsScreen.render(sb);
                break;
            }
            case MAP: {
                dungeonMapScreen.render(sb);
                break;
            }
            case GRID: {
                gridSelectScreen.render(sb);
                break;
            }
            case CARD_REWARD: {
                cardRewardScreen.render(sb);
                break;
            }
            case COMBAT_REWARD: {
                combatRewardScreen.render(sb);
                break;
            }
            case BOSS_REWARD: {
                bossRelicScreen.render(sb);
                break;
            }
            case HAND_SELECT: {
                handCardSelectScreen.render(sb);
                break;
            }
            case SHOP: {
                shopScreen.render(sb);
                break;
            }
            case DEATH: {
                deathScreen.render(sb);
                break;
            }
            case UNLOCK: {
                unlockScreen.render(sb);
                break;
            }
            case GASHA_UNLOCK: {
                gUnlockScreen.render(sb);
                break;
            }
            case CREDITS: {
                creditsScreen.render(sb);
            }
            case FTUE: {
                break;
            }
            default: {
                logger.info("ERROR: UNKNOWN SCREEN TO RENDER: " + screen.name());
            }
        }
        if (screen != CurrentScreen.UNLOCK) {
            sb.setColor(topGradientColor);
            if (!Settings.hideTopBar) {
                sb.draw(ImageMaster.SCROLL_GRADIENT, 0.0f, (float)Settings.HEIGHT - 128.0f * Settings.scale, (float)Settings.WIDTH, 64.0f * Settings.scale);
            }
            sb.setColor(botGradientColor);
            if (!Settings.hideTopBar) {
                sb.draw(ImageMaster.SCROLL_GRADIENT, 0.0f, 64.0f * Settings.scale, (float)Settings.WIDTH, -64.0f * Settings.scale);
            }
        }
        if (screen == CurrentScreen.FTUE) {
            ftue.render(sb);
        }
        AbstractDungeon.overlayMenu.cancelButton.render(sb);
        dynamicBanner.render(sb);
        if (screen != CurrentScreen.UNLOCK) {
            topPanel.render(sb);
        }
        AbstractDungeon.currMapNode.room.renderAboveTopPanel(sb);
        for (AbstractGameEffect e : topLevelEffects) {
            if (e.renderBehind) continue;
            e.render(sb);
        }
        sb.setColor(fadeColor);
        sb.draw(ImageMaster.WHITE_SQUARE_IMG, 0.0f, 0.0f, (float)Settings.WIDTH, (float)Settings.HEIGHT);
    }

    public void updateFading() {
        if (isFadingIn) {
            AbstractDungeon.fadeColor.a = Interpolation.fade.apply(0.0f, 1.0f, (fadeTimer -= Gdx.graphics.getDeltaTime()) / 0.8f);
            if (fadeTimer < 0.0f) {
                isFadingIn = false;
                AbstractDungeon.fadeColor.a = 0.0f;
                fadeTimer = 0.0f;
            }
        } else if (isFadingOut) {
            AbstractDungeon.fadeColor.a = Interpolation.fade.apply(1.0f, 0.0f, (fadeTimer -= Gdx.graphics.getDeltaTime()) / 0.8f);
            if (fadeTimer < 0.0f) {
                fadeTimer = 0.0f;
                isFadingOut = false;
                AbstractDungeon.fadeColor.a = 1.0f;
                if (!isDungeonBeaten) {
                    this.nextRoomTransition();
                }
            }
        }
    }

    public static void closeCurrentScreen() {
        switch (screen) {
            case MASTER_DECK_VIEW: {
                AbstractDungeon.overlayMenu.cancelButton.hide();
                AbstractDungeon.genericScreenOverlayReset();
                for (AbstractCard c : AbstractDungeon.player.masterDeck.group) {
                    c.unhover();
                    c.untip();
                }
                break;
            }
            case DISCARD_VIEW: {
                AbstractDungeon.overlayMenu.cancelButton.hide();
                AbstractDungeon.genericScreenOverlayReset();
                for (AbstractCard c : AbstractDungeon.player.discardPile.group) {
                    c.drawScale = 0.12f;
                    c.targetDrawScale = 0.12f;
                    c.teleportToDiscardPile();
                    c.darken(true);
                    c.unhover();
                }
                break;
            }
            case FTUE: {
                AbstractDungeon.genericScreenOverlayReset();
                break;
            }
            case GAME_DECK_VIEW: {
                AbstractDungeon.overlayMenu.cancelButton.hide();
                AbstractDungeon.genericScreenOverlayReset();
                break;
            }
            case SETTINGS: {
                AbstractDungeon.overlayMenu.cancelButton.hide();
                AbstractDungeon.genericScreenOverlayReset();
                dynamicButton.hide();
                AbstractDungeon.settingsScreen.abandonPopup.hide();
                AbstractDungeon.settingsScreen.exitPopup.hide();
                break;
            }
            case GASHA_UNLOCK: {
                AbstractDungeon.genericScreenOverlayReset();
                dynamicButton.hide();
                CardCrawlGame.sound.stop("UNLOCK_SCREEN", AbstractDungeon.gUnlockScreen.id);
                break;
            }
            case GRID: {
                AbstractDungeon.genericScreenOverlayReset();
                break;
            }
            case CARD_REWARD: {
                AbstractDungeon.overlayMenu.cancelButton.hide();
                dynamicBanner.hide();
                AbstractDungeon.genericScreenOverlayReset();
                break;
            }
            case COMBAT_REWARD: {
                dynamicButton.hide();
                dynamicBanner.hide();
                AbstractDungeon.genericScreenOverlayReset();
                break;
            }
            case BOSS_REWARD: {
                AbstractDungeon.genericScreenOverlayReset();
                dynamicBanner.hide();
                break;
            }
            case HAND_SELECT: {
                AbstractDungeon.genericScreenOverlayReset();
                AbstractDungeon.handCardSelectScreen.button.isDisabled = true;
                AbstractDungeon.handCardSelectScreen.button.hitbox.unhover();
                AbstractDungeon.handCardSelectScreen.button.hide();
                overlayMenu.showCombatPanels();
                break;
            }
            case MAP: {
                AbstractDungeon.genericScreenOverlayReset();
                dungeonMapScreen.close();
                if (firstRoomChosen || nextRoom == null || AbstractDungeon.dungeonMapScreen.dismissable) break;
                firstRoomChosen = true;
                AbstractDungeon.firstRoomLogic();
                break;
            }
            case SHOP: {
                CardCrawlGame.sound.play("SHOP_CLOSE");
                AbstractDungeon.genericScreenOverlayReset();
                AbstractDungeon.overlayMenu.cancelButton.hide();
                break;
            }
            case TRANSFORM: {
                CardCrawlGame.sound.play("ATTACK_MAGIC_SLOW_1");
                AbstractDungeon.genericScreenOverlayReset();
                AbstractDungeon.overlayMenu.cancelButton.hide();
                break;
            }
            default: {
                logger.info("UNSPECIFIED CASE: " + screen.name());
            }
        }
        if (previousScreen == null) {
            screen = CurrentScreen.NONE;
        } else if (screenSwap) {
            screenSwap = false;
        } else {
            screen = previousScreen;
            previousScreen = null;
            isScreenUp = true;
            AbstractDungeon.openPreviousScreen(screen);
        }
    }

    private static void openPreviousScreen(CurrentScreen s) {
        switch (s) {
            case DEATH: {
                deathScreen.reopen();
                break;
            }
            case MASTER_DECK_VIEW: {
                deckViewScreen.open();
                break;
            }
            case CARD_REWARD: {
                cardRewardScreen.reopen();
                if (AbstractDungeon.cardRewardScreen.rItem == null) break;
                previousScreen = CurrentScreen.COMBAT_REWARD;
                break;
            }
            case COMBAT_REWARD: {
                combatRewardScreen.reopen();
                break;
            }
            case BOSS_REWARD: {
                bossRelicScreen.reopen();
                break;
            }
            case SHOP: {
                shopScreen.open();
                break;
            }
            case GRID: {
                gridSelectScreen.reopen();
                break;
            }
            case GASHA_UNLOCK: {
                gUnlockScreen.reOpen();
                break;
            }
        }
    }

    private static void genericScreenOverlayReset() {
        if (previousScreen == null) {
            if (AbstractDungeon.player.isDead) {
                previousScreen = CurrentScreen.DEATH;
            } else {
                isScreenUp = false;
                overlayMenu.hideBlackScreen();
            }
        }
        if (AbstractDungeon.getCurrRoom().phase == AbstractRoom.RoomPhase.COMBAT && !AbstractDungeon.player.isDead) {
            overlayMenu.showCombatPanels();
        }
    }

    public static void fadeIn() {
        if (AbstractDungeon.fadeColor.a != 1.0f) {
            logger.info("WARNING: Attempting to fade in even though screen is not black");
        }
        isFadingIn = true;
        fadeTimer = !CardCrawlGame.fastMode ? 0.8f : 0.02f;
    }

    public static void fadeOut() {
        if (fadeTimer == 0.0f) {
            if (AbstractDungeon.fadeColor.a != 0.0f) {
                logger.info("WARNING: Attempting to fade out even though screen is not transparent");
            }
            isFadingOut = true;
            fadeTimer = !CardCrawlGame.fastMode ? 0.8f : 0.02f;
        }
    }

    public static void dungeonTransitionSetup() {
        if (AbstractDungeon.cardRng.counter > 0 && AbstractDungeon.cardRng.counter < 250) {
            cardRng.setCounter(250);
        } else if (AbstractDungeon.cardRng.counter > 250 && AbstractDungeon.cardRng.counter < 500) {
            cardRng.setCounter(500);
        } else if (AbstractDungeon.cardRng.counter > 500 && AbstractDungeon.cardRng.counter < 750) {
            cardRng.setCounter(750);
        }
        logger.info("CardRng Counter: " + AbstractDungeon.cardRng.counter);
        topPanel.unhoverHitboxes();
        pathX.clear();
        pathY.clear();
        EventHelper.resetProbabilities();
        eventList.clear();
        shrineList.clear();
        monsterList.clear();
        eliteMonsterList.clear();
        bossList.clear();
        AbstractRoom.blizzardPotionMod = 0;
        if (!DailyMods.mods.get("Restless Journey").booleanValue()) {
            player.heal(AbstractDungeon.player.maxHealth, false);
        }
        AbstractDungeon.dungeonMapScreen.map.atBoss = false;
    }

    public static void reset() {
        floorNum = 0;
        if (AbstractDungeon.getCurrRoom().monsters != null) {
            for (AbstractMonster m : AbstractDungeon.getCurrRoom().monsters.monsters) {
                m.dispose();
            }
        }
        dialog.clear();
        dialog = null;
        genericEventDialog.clear();
        genericEventDialog = null;
        relicsToRemoveOnStart.clear();
        previousScreen = null;
        dialog = new RoomEventDialog();
        genericEventDialog = new GenericEventDialog();
        actionManager.clear();
        actionManager.clearNextRoomCombatActions();
        effectList.clear();
        effectsQueue.clear();
        topLevelEffectsQueue.clear();
        topLevelEffects.clear();
        firstChest = true;
        encounteredCursedChest = false;
        rs = RenderScene.NORMAL;
    }

    protected void removeRelicFromPool(ArrayList<String> pool, String name) {
        Iterator<String> i = pool.iterator();
        while (i.hasNext()) {
            String s = i.next();
            if (!s.equals(name)) continue;
            i.remove();
            logger.info("Relic" + s + " removed from relic pool.");
        }
    }

    public static void onModifyPower() {
        if (player != null) {
            AbstractDungeon.player.hand.applyPowers();
        }
        if (AbstractDungeon.getCurrRoom().monsters != null) {
            for (AbstractMonster m : AbstractDungeon.getCurrRoom().monsters.monsters) {
                m.applyPowers();
            }
        }
    }

    public void checkForPurityAndPactAchievement() {
        if (player != null) {
            if (AbstractDungeon.player.exhaustPile.size() >= 20) {
                UnlockTracker.unlockAchievement("THE_PACT");
            }
            if (AbstractDungeon.player.hand.size() + AbstractDungeon.player.drawPile.size() + AbstractDungeon.player.discardPile.size() <= 3) {
                UnlockTracker.unlockAchievement("PURITY");
            }
        }
    }

    public void loadSave(SaveFile saveFile) {
        playtimeStart = playtimeStart - saveFile.play_time;
        floorNum = saveFile.floor_num;
        Settings.seed = saveFile.seed;
        AbstractDungeon.loadSeeds(saveFile);
        monsterList = saveFile.monster_list;
        eliteMonsterList = saveFile.elite_monster_list;
        bossList = saveFile.boss_list;
        bossKey = saveFile.boss;
        commonRelicPool = saveFile.common_relics;
        uncommonRelicPool = saveFile.uncommon_relics;
        rareRelicPool = saveFile.rare_relics;
        shopRelicPool = saveFile.shop_relics;
        bossRelicPool = saveFile.boss_relics;
        pathX = saveFile.path_x;
        pathY = saveFile.path_y;
        bossCount = saveFile.spirit_count;
        eventList = saveFile.event_list;
        specialOneTimeEventList = saveFile.one_time_event_list;
        EventHelper.setChances(saveFile.event_chances);
        AbstractRoom.blizzardPotionMod = saveFile.potion_chance;
        ShopScreen.purgeCost = saveFile.purgeCost;
        CardHelper.obtainedCards = saveFile.obtained_cards;
    }

    static {
        floorNum = 0;
        unlocks = new ArrayList();
        shrineChance = 0.25f;
        firstChest = true;
        encounteredCursedChest = false;
        loading_post_combat = false;
        srcColorlessCardPool = new CardGroup(CardGroup.CardGroupType.CARD_POOL);
        srcCurseCardPool = new CardGroup(CardGroup.CardGroupType.CARD_POOL);
        srcCommonCardPool = new CardGroup(CardGroup.CardGroupType.CARD_POOL);
        srcUncommonCardPool = new CardGroup(CardGroup.CardGroupType.CARD_POOL);
        srcRareCardPool = new CardGroup(CardGroup.CardGroupType.CARD_POOL);
        colorlessCardPool = new CardGroup(CardGroup.CardGroupType.CARD_POOL);
        curseCardPool = new CardGroup(CardGroup.CardGroupType.CARD_POOL);
        commonCardPool = new CardGroup(CardGroup.CardGroupType.CARD_POOL);
        uncommonCardPool = new CardGroup(CardGroup.CardGroupType.CARD_POOL);
        rareCardPool = new CardGroup(CardGroup.CardGroupType.CARD_POOL);
        acceptablePools = new ArrayList();
        commonRelicPool = new ArrayList();
        uncommonRelicPool = new ArrayList();
        rareRelicPool = new ArrayList();
        shopRelicPool = new ArrayList();
        bossRelicPool = new ArrayList();
        lastMonsterKey = null;
        lastCombatMetricKey = null;
        monsterList = new ArrayList();
        eliteMonsterList = new ArrayList();
        bossList = new ArrayList();
        eventList = new ArrayList();
        shrineList = new ArrayList();
        specialOneTimeEventList = new ArrayList();
        actionManager = new GameActionManager();
        topLevelEffects = new ArrayList();
        topLevelEffectsQueue = new ArrayList();
        effectList = new ArrayList();
        effectsQueue = new ArrayList();
        turnPhaseEffectActive = false;
        firstRoomChosen = false;
        rs = RenderScene.NORMAL;
        pathX = new ArrayList();
        pathY = new ArrayList();
        topGradientColor = new Color(1.0f, 1.0f, 1.0f, 0.25f);
        botGradientColor = new Color(1.0f, 1.0f, 1.0f, 0.25f);
        floorY = 340.0f * Settings.scale;
        dialog = new RoomEventDialog();
        genericEventDialog = new GenericEventDialog();
        topPanel = new TopPanel();
        cardRewardScreen = new CardRewardScreen();
        combatRewardScreen = new CombatRewardScreen();
        bossRelicScreen = new BossRelicSelectScreen();
        deckViewScreen = new MasterDeckViewScreen();
        discardPileViewScreen = new DiscardPileViewScreen();
        gameDeckViewScreen = new DrawPileViewScreen();
        settingsScreen = new SettingsScreen();
        dungeonMapScreen = new DungeonMapScreen();
        gridSelectScreen = new GridCardSelectScreen();
        handCardSelectScreen = new HandCardSelectScreen();
        shopScreen = new ShopScreen();
        creditsScreen = null;
        ftue = null;
        unlockScreen = new UnlockCharacterScreen();
        gUnlockScreen = new GashaUnlockScreen();
        isScreenUp = false;
        screenSwap = false;
        cardBlizzRandomizer = cardBlizzStartOffset = 5;
        cardBlizzGrowth = 1;
        cardBlizzMaxOffset = -40;
        relicsToRemoveOnStart = new ArrayList();
        bossCount = 0;
        LOGGER = LogManager.getLogger(AbstractDungeon.class.getName());
    }

    public static enum RenderScene {
        NORMAL,
        EVENT,
        CAMPFIRE;

    }

    public static enum CurrentScreen {
        NONE,
        MASTER_DECK_VIEW,
        SETTINGS,
        GRID,
        MAP,
        FTUE,
        CHOOSE_ONE,
        HAND_SELECT,
        SHOP,
        COMBAT_REWARD,
        DISCARD_VIEW,
        GAME_DECK_VIEW,
        BOSS_REWARD,
        DEATH,
        CARD_REWARD,
        TRANSFORM,
        VICTORY,
        UNLOCK,
        CREDITS,
        GASHA_UNLOCK;

    }
}

